function drag_and_drop_M(fig_handle, ~, system)
% function drag_and_drop should be attached to WindowButtonMotionFcn
handles = guihandles(fig_handle);
pos = get(fig_handle, 'currentpoint');  % get mouse location on figure
x = pos(1);
y = pos(2);          % assign locations to x and y

%%  get position information of the uicontrol

[lx_sb,ly_sb,lw_sb,lh_sb] = get_positon(handles.Sand_box); %sand box bound
[lx_sys,ly_sys,lw_sys,lh_sys] = get_positon(handles.System_panel); %system bound
[lx_C_1,ly_C_1,lw_C_1,lh_C_1] = get_positon(handles.TA_Compliance_bt);% bounds component 1
[lx_C_2,ly_C_2,lw_C_2,lh_C_2] = get_positon(handles.TA_Jacket_Target_bt);% bounds component 2
[lx_C_3,ly_C_3,lw_C_3,lh_C_3] = get_positon(handles.TA_Round_Duct_bt);% bounds component 3

%% drag new component to sand box
% test to see if mouse is within the one of the components
if x >= lx_C_1 && x <= (lx_C_1 + lw_C_1) && y >= ly_C_1 && y <= (ly_C_1 + lh_C_1)
    % set enable to off the whole uicontrol is hotspot
    setfigptr('hand', fig_handle);
    %set(fig_handle,'WindowButtonMotionFcn', @Drag_and_drop_new_components); 
elseif x >= lx_C_2 && x <= (lx_C_2 + lw_C_2) && y >= ly_C_2 && y <= (ly_C_2 + lh_C_2)
    % set enable to off the whole uicontrol is hotspot
    setfigptr('hand', fig_handle);
    %set(fig_handle,'WindowButtonMotionFcn', @Drag_and_drop_new_components); 
elseif x >= lx_C_3 && x <= (lx_C_3 + lw_C_3) && y >= ly_C_3 && y <= (ly_C_3 + lh_C_3)
    % set enable to off the whole uicontrol is hotspot
    setfigptr('hand', fig_handle);
%% Move Component within the sand box
elseif x >= lx_sb && x <= (lx_sb + lw_sb) && y >= ly_sb && y <= (ly_sb + lh_sb)
    set(fig_handle,'WindowButtonMotionFcn', {@drag_component_in_sand_box,system});
%% Move Component within the system
elseif x >= lx_sys && x <= (lx_sys + lw_sys) && y >= ly_sys && y <= (ly_sys + lh_sys)
    % re-enable the uicontrol
    set(fig_handle,'WindowButtonMotionFcn', {@drag_component_in_sand_box,system});
else
    setfigptr('arrow', fig_handle);
end


end % end of drag_and_drop function